// childTest.c
// Shows how to identify your self as a parent/child after fork without using
// fork's return value.
// jbs

#include <unistd.h>    // fork, getpid
#include <stdio.h>     // printf, perror
#include <sys/types.h> // pid_t

int main() {

    pid_t parent_pid = getpid();
    printf("Parent id: %d\n", parent_pid);
    pid_t fork_pid = fork();
    if (fork_pid == -1) perror("fork failed");
    pid_t new_pid = getpid();
    if (parent_pid == new_pid)
        printf("Yes, I (%d) am the parent and fork said %d\n",
               new_pid, fork_pid);
    else
        printf("No, I (%d) am not the parent and fork said %d\n",
               new_pid, fork_pid);

    return 0;
}
